/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity.projectile;

import dev.toma.gunsrpg.common.entity.projectile.AbstractExplosive;
import dev.toma.gunsrpg.common.entity.projectile.IReaction;
import dev.toma.gunsrpg.common.item.guns.util.IEntityTrackingGun;
import dev.toma.gunsrpg.util.object.LazyLoader;
import dev.toma.gunsrpg.util.properties.Properties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class Rocket
extends AbstractExplosive {
    private final GuidedController controller = new GuidedController();
    private final LazyLoader<TrackedTarget> target = new LazyLoader<TrackedTarget>(this::getTarget);
    private float velocity;

    public Rocket(EntityType<? extends Rocket> type, World world) {
        super((EntityType<? extends AbstractExplosive>)type, world);
    }

    public Rocket(EntityType<? extends Rocket> type, World world, LivingEntity entity) {
        super((EntityType<? extends AbstractExplosive>)type, world, entity);
    }

    @Override
    public void setup(float damage, float velocity, int delay) {
        super.setup(damage, velocity, delay);
        this.velocity = velocity;
    }

    @Override
    public void writeSpawnData(PacketBuffer buffer) {
        super.writeSpawnData(buffer);
        buffer.writeFloat(this.velocity);
    }

    @Override
    public void readSpawnData(PacketBuffer buffer) {
        super.readSpawnData(buffer);
        this.velocity = buffer.readFloat();
    }

    @Override
    protected void updateDirection() {
        if (this.isGuided() && this.field_70173_aa > 2) {
            TrackedTarget trackedTarget = this.target.get();
            trackedTarget.update();
            this.controller.update(trackedTarget);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
        } else {
            Vector3d delta = this.func_213322_ci();
            double dx = delta.field_72450_a;
            double dy = delta.field_72448_b;
            double dz = delta.field_72449_c;
            float motionSqrt = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
            this.field_70127_C = this.field_70125_A = -((float)(MathHelper.func_181159_b((double)dy, (double)motionSqrt) * 57.29577951308232));
        }
    }

    @Override
    public void onCollided(Vector3d impact) {
        IReaction reaction = this.getProperty(Properties.REACTION);
        if (reaction != null) {
            reaction.react(this, impact, this.field_70170_p);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    @Override
    public void postTick() {
        boolean propelled = this.getProperty(Properties.FUELED);
        if (propelled) {
            if (this.field_70170_p.field_72995_K && this.canApplyGravity()) {
                Vector3d movement = this.func_213322_ci().func_216372_d(-0.3, -0.3, -0.3);
                for (int i = 0; i < 5; ++i) {
                    double rx = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)0.05f;
                    double ry = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)0.05f;
                    double rz = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)0.05f;
                    this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197631_x, true, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), movement.field_72450_a + rx, movement.field_72448_b + ry, movement.field_72449_c + rz);
                }
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197613_f, true, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), movement.field_72450_a, movement.field_72448_b, movement.field_72449_c);
            }
            if (this.field_70173_aa > 100) {
                this.onCollided(this.func_213303_ch());
            }
            if (this.isGuided()) {
                Vector3d currentPos = this.func_213303_ch();
                Vector3d nextPos = currentPos.func_178787_e(this.func_213322_ci());
                TrackedTarget target = this.getTarget();
                if (target.entity != null) {
                    Vector3d targetPos = TrackedTarget.atCenterOfEntity(target.entity);
                    double distance1 = currentPos.func_72436_e(targetPos);
                    double distance2 = nextPos.func_72436_e(targetPos);
                    IEntityTrackingGun.GuidenanceProperties properties = this.getProperty(Properties.GUIDENANCE);
                    if (distance2 > distance1 && distance1 <= (double)properties.getMaxProximityDistanceSqr()) {
                        this.onCollided(currentPos);
                    }
                }
            }
        } else {
            this.applyGravity(0.02f);
            if (this.field_70170_p.field_72995_K) {
                Vector3d movement = this.func_213322_ci().func_216372_d(-0.4, -0.4, -0.4);
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197601_L, true, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), movement.field_72450_a, movement.field_72448_b, movement.field_72449_c);
            }
        }
    }

    @Override
    public boolean func_70112_a(double distance) {
        return true;
    }

    private boolean isGuided() {
        return this.getTarget().entity != null;
    }

    private TrackedTarget getTarget() {
        int id = this.getProperty(Properties.ENTITY_ID);
        Entity entity = this.field_70170_p.func_73045_a(id);
        return new TrackedTarget(entity);
    }

    private static class TrackedTarget {
        private final Entity entity;
        private Vector3d pos;

        public TrackedTarget(Entity entity) {
            this.entity = entity;
        }

        Vector3d getTrackedPosition() {
            return this.pos;
        }

        void update() {
            if (this.entity == null && this.pos.field_72448_b > 0.0) {
                this.pos = new Vector3d(this.pos.field_72450_a, 0.0, this.pos.field_72449_c);
                return;
            }
            this.pos = TrackedTarget.atCenterOfEntity(this.entity);
        }

        static Vector3d atCenterOfEntity(Entity entity) {
            EntitySize size = entity.func_213305_a(entity.func_213283_Z());
            Vector3d position = entity.func_213303_ch();
            return position.func_72441_c((double)(size.field_220315_a / 2.0f), (double)(size.field_220316_b / 2.0f), (double)(size.field_220315_a / 2.0f));
        }
    }

    private final class GuidedController {
        private GuidedController() {
        }

        void update(TrackedTarget target) {
            IEntityTrackingGun.GuidenanceProperties properties;
            Rocket rocket = Rocket.this;
            Vector3d position = target.getTrackedPosition();
            double angleDegrees = this.getAngleTowardsTarget(rocket.func_213322_ci(), position.func_178788_d(rocket.func_213303_ch()));
            boolean hasGuidance = angleDegrees <= (double)(properties = rocket.getProperty(Properties.GUIDENANCE)).getMaxGuidenanceAngle();
            float x = rocket.field_70125_A;
            float y = rocket.field_70177_z;
            if (hasGuidance) {
                rocket.field_70125_A = this.rotateTowards(x, this.getVerticalDifference(position), properties.getMaxPitch());
                rocket.field_70177_z = this.rotateTowards(y, this.getHorizontalDifference(position), properties.getMaxYaw());
            }
            float f = rocket.velocity;
            if (!rocket.getProperty(Properties.FUELED).booleanValue() && Rocket.this.field_70173_aa > 15) {
                return;
            }
            Vector3d look = Vector3d.func_189986_a((float)rocket.field_70125_A, (float)rocket.field_70177_z);
            Rocket.this.func_213317_d(look.func_216372_d((double)f, (double)f, (double)f));
        }

        float getVerticalDifference(Vector3d target) {
            Vector3d pos = Rocket.this.func_213303_ch();
            double x = target.field_72450_a - pos.field_72450_a;
            double y = target.field_72448_b - pos.field_72448_b;
            double z = target.field_72449_c - pos.field_72449_c;
            double dist = MathHelper.func_76133_a((double)(x * x + z * z));
            return (float)(-(MathHelper.func_181159_b((double)y, (double)dist) * 57.29577951308232));
        }

        float getHorizontalDifference(Vector3d target) {
            Vector3d pos = Rocket.this.func_213303_ch();
            double x = target.field_72450_a - pos.field_72450_a;
            double z = target.field_72449_c - pos.field_72449_c;
            return (float)(MathHelper.func_181159_b((double)z, (double)x) * 57.29577951308232) - 90.0f;
        }

        float rotateTowards(float currentRotation, float targetRotation, float maxStepSize) {
            float difference = MathHelper.func_203302_c((float)currentRotation, (float)targetRotation);
            float clampedMovement = MathHelper.func_76131_a((float)difference, (float)(-maxStepSize), (float)maxStepSize);
            return currentRotation + clampedMovement;
        }

        double getAngleTowardsTarget(Vector3d vecA, Vector3d vecB) {
            double aLen = vecA.func_72433_c();
            double bLen = vecB.func_72433_c();
            double a = vecA.field_72450_a * vecB.field_72450_a + vecA.field_72448_b + vecB.field_72448_b + vecA.field_72449_c * vecB.field_72449_c;
            double b = aLen * bLen;
            double angleRad = Math.acos(a / b);
            return Math.toDegrees(angleRad);
        }
    }
}

